/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.a.ArchfiendOfSpiteEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class ArchfiendOfSpiteAbility
extends TriggeredAbilityImpl {
    ArchfiendOfSpiteAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private ArchfiendOfSpiteAbility(ArchfiendOfSpiteAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ArchfiendOfSpiteAbility copy() {
        return new ArchfiendOfSpiteAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getTargetId().equals(this.getSourceId())) {
            return false;
        }
        UUID sourceControllerId = game.getControllerId(event.getSourceId());
        if (sourceControllerId == null || !game.getOpponents(this.getControllerId()).contains(sourceControllerId)) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new ArchfiendOfSpiteEffect(event.getAmount(), sourceControllerId));
        return true;
    }

    public String getRule() {
        return "Whenever a source an opponent controls deals damage to {this}, that source's controller loses that much life unless they sacrifice that many permanents.";
    }
}

