/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.List;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.a.ArchfiendsVesselEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.watchers.common.SpellsCastWatcher;

class ArchfiendsVesselAbility
extends EntersBattlefieldTriggeredAbility {
    ArchfiendsVesselAbility() {
        super((Effect)new ArchfiendsVesselEffect());
    }

    private ArchfiendsVesselAbility(ArchfiendsVesselAbility ability) {
        super((EntersBattlefieldTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (super.checkTrigger(event, game) && event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD) {
            EntersTheBattlefieldEvent entersTheBattlefieldEvent = (EntersTheBattlefieldEvent)event;
            if (entersTheBattlefieldEvent.getTargetId().equals(this.getSourceId()) && entersTheBattlefieldEvent.getFromZone() == Zone.GRAVEYARD) {
                return true;
            }
            SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
            List spellsCastFromGraveyard = watcher.getSpellsCastFromGraveyardThisTurn(this.getControllerId());
            if (spellsCastFromGraveyard != null) {
                return spellsCastFromGraveyard.stream().anyMatch(spell -> spell.getMainCard().getId().equals(entersTheBattlefieldEvent.getTarget().getMainCard().getId()));
            }
        }
        return false;
    }

    public ArchfiendsVesselAbility copy() {
        return new ArchfiendsVesselAbility(this);
    }
}

