/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ArchghoulOfThrabenEffect
extends OneShotEffect {
    ArchghoulOfThrabenEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top card of your library. If it's a Zombie card, you may reveal it and put it into your hand. If you don't put the card into your hand, you may put it into your graveyard";
    }

    private ArchghoulOfThrabenEffect(ArchghoulOfThrabenEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArchghoulOfThrabenEffect copy() {
        return new ArchghoulOfThrabenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card topCard = controller.getLibrary().getFromTop(game);
        if (topCard == null) {
            return false;
        }
        controller.lookAtCards("Top card of library", topCard, game);
        if (topCard.hasSubtype(SubType.ZOMBIE, game) && controller.chooseUse(Outcome.DrawCard, "Reveal " + topCard.getName() + " and put it into your hand?", source, game)) {
            controller.revealCards(source, (Cards)new CardsImpl(topCard), game);
            controller.moveCards(topCard, Zone.HAND, source, game);
            return true;
        }
        if (controller.chooseUse(Outcome.Neutral, "Put " + topCard.getName() + " into your graveyard?", source, game)) {
            controller.moveCards(topCard, Zone.GRAVEYARD, source, game);
        }
        return true;
    }
}

