/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderYourControlTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ArgentSphinxEffect
extends OneShotEffect {
    private static final String effectText = "Exile {this}. Return it to the battlefield under your control at the beginning of the next end step";

    ArgentSphinxEffect() {
        super(Outcome.Benefit);
        this.staticText = effectText;
    }

    private ArgentSphinxEffect(ArgentSphinxEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || permanent == null) {
            return false;
        }
        Card card = permanent.getMainCard();
        player.moveCards((Card)permanent, Zone.EXILED, source, game);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new ReturnToBattlefieldUnderYourControlTargetEffect().setText("Return it to the battlefield under your control at the beginning of the next end step").setTargetPointer((TargetPointer)new FixedTarget(card, game))), source);
        return true;
    }

    public ArgentSphinxEffect copy() {
        return new ArgentSphinxEffect(this);
    }
}

