/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class ArmoredAscension
extends CardImpl {
    private static final FilterLandPermanent filter = new FilterLandPermanent("Plains you control");
    private static final DynamicValue xValue;
    private static final Hint hint;

    public ArmoredAscension(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{3}{W}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        SimpleStaticAbility ability = new SimpleStaticAbility((Effect)new BoostEnchantedEffect(xValue, xValue, Duration.WhileOnBattlefield));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)FlyingAbility.getInstance(), AttachmentType.AURA).setText("and has flying"));
        this.addAbility(ability.addHint(hint));
    }

    private ArmoredAscension(ArmoredAscension card) {
        super((CardImpl)card);
    }

    public ArmoredAscension copy() {
        return new ArmoredAscension(this);
    }

    static {
        filter.add((Predicate)SubType.PLAINS.getPredicate());
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        xValue = new PermanentsOnBattlefieldCount((FilterPermanent)filter);
        hint = new ValueHint("Plains you control", xValue);
    }
}

