/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GreatestAmongPermanentsValue;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBasePowerSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ArniBrokenbrowEffect
extends OneShotEffect {
    ArniBrokenbrowEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "you may change {this}'s base power to 1 plus the greatest power among other creatures you control until end of turn";
    }

    private ArniBrokenbrowEffect(ArniBrokenbrowEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArniBrokenbrowEffect copy() {
        return new ArniBrokenbrowEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject mageObject = game.getObject(source);
        if (controller == null || mageObject == null) {
            return false;
        }
        int power = GreatestAmongPermanentsValue.POWER_OTHER_CONTROLLED_CREATURES.calculate(game, source, (Effect)this);
        if (controller.chooseUse(this.outcome, "Change base power of " + mageObject.getLogName() + " to " + ++power + " until end of turn?", source, game)) {
            game.addEffect((ContinuousEffect)new SetBasePowerSourceEffect(power, Duration.EndOfTurn), source);
            return true;
        }
        return false;
    }
}

