/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class ArniMetalbrowEffect
extends OneShotEffect {
    ArniMetalbrowEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may put a creature card with mana value less than that creature's mana value from your hand onto the battlefield tapped and attacking";
    }

    private ArniMetalbrowEffect(ArniMetalbrowEffect effect) {
        super((OneShotEffect)effect);
    }

    public ArniMetalbrowEffect copy() {
        return new ArniMetalbrowEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = (Permanent)this.getValue("attacker");
        if (player == null || permanent == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)player.getHand());
        cards.removeIf(uuid -> !game.getCard(uuid).isCreature(game));
        cards.removeIf(uuid -> game.getCard(uuid).getManaValue() >= permanent.getManaValue());
        if (cards.isEmpty()) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        target.withChooseHint("to put onto the battlefield tapped and attacking");
        player.choose(Outcome.PutCreatureInPlay, (Cards)cards, (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        Permanent creature = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (creature != null) {
            game.getCombat().addAttackingCreature(creature.getId(), game);
        }
        return true;
    }
}

