/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AshZealotTriggeredAbility
extends TriggeredAbilityImpl {
    public AshZealotTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(3), false);
    }

    private AshZealotTriggeredAbility(AshZealotTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AshZealotTriggeredAbility copy() {
        return new AshZealotTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        if (event.getZone() == Zone.GRAVEYARD && (spell = game.getStack().getSpell(event.getTargetId())) != null) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(spell.getControllerId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a player casts a spell from a graveyard, {this} deals 3 damage to that player.";
    }
}

