/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class AshesOfTheAbhorrentEffect
extends ContinuousRuleModifyingEffectImpl {
    AshesOfTheAbhorrentEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "Players can't cast spells from graveyards or activate abilities of cards in graveyards";
    }

    private AshesOfTheAbhorrentEffect(AshesOfTheAbhorrentEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public AshesOfTheAbhorrentEffect copy() {
        return new AshesOfTheAbhorrentEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL || event.getType() == GameEvent.EventType.ACTIVATE_ABILITY;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Zone zone;
        Card card = game.getCard(event.getSourceId());
        return card != null && (zone = game.getState().getZone(card.getId())) != null && zone == Zone.GRAVEYARD;
    }
}

