/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class AshiokDreamRenderEffect
extends ContinuousRuleModifyingEffectImpl {
    AshiokDreamRenderEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, true, false);
        this.staticText = "Spells and abilities your opponents control can't cause their controller to search their library.";
    }

    private AshiokDreamRenderEffect(AshiokDreamRenderEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public AshiokDreamRenderEffect copy() {
        return new AshiokDreamRenderEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't search libraries (" + mageObject.getLogName() + " in play).";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return GameEvent.EventType.SEARCH_LIBRARY == event.getType();
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        return controller != null && event.getPlayerId().equals(game.getControllerId(event.getSourceId())) && event.getTargetId().equals(game.getControllerId(event.getSourceId())) && controller.hasOpponent(game.getControllerId(event.getSourceId()), game);
    }
}

