/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class AshiokNightmareMuseBounceEffect
extends OneShotEffect {
    AshiokNightmareMuseBounceEffect() {
        super(Outcome.Discard);
        this.staticText = "return target nonland permanent to its owner's hand, then that player exiles a card from their hand";
    }

    private AshiokNightmareMuseBounceEffect(AshiokNightmareMuseBounceEffect effect) {
        super((OneShotEffect)effect);
    }

    public AshiokNightmareMuseBounceEffect copy() {
        return new AshiokNightmareMuseBounceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        Player player = game.getPlayer(game.getOwnerId(source.getFirstTarget()));
        if (permanent == null || player == null) {
            return false;
        }
        player.moveCards((Card)permanent, Zone.HAND, source, game);
        if (player.getHand().isEmpty()) {
            return true;
        }
        TargetCardInHand target = new TargetCardInHand();
        if (!player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game)) {
            return false;
        }
        return player.moveCards(game.getCard(target.getFirstTarget()), Zone.EXILED, source, game);
    }
}

