/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageEverythingEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class AshlingThePilgrimEffect
extends OneShotEffect {
    AshlingThePilgrimEffect() {
        super(Outcome.Damage);
        this.staticText = "remove all +1/+1 counters from {this}, and it deals that much damage to each creature and each player";
    }

    private AshlingThePilgrimEffect(AshlingThePilgrimEffect effect) {
        super((OneShotEffect)effect);
    }

    public AshlingThePilgrimEffect copy() {
        return new AshlingThePilgrimEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent == null) {
            return false;
        }
        int amountRemoved = sourcePermanent.removeAllCounters(CounterType.P1P1.getName(), source, game);
        new DamageEverythingEffect(amountRemoved, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE).apply(game, source);
        return true;
    }
}

