/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class AspiringChampionEffect
extends OneShotEffect {
    AspiringChampionEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice it. If you do, reveal cards from the top of your library until you reveal a creature card. Put that card onto the battlefield, then shuffle the rest into your library. If that creature is a Demon, it deals damage equal to its power to each opponent";
    }

    private AspiringChampionEffect(AspiringChampionEffect effect) {
        super((OneShotEffect)effect);
    }

    public AspiringChampionEffect copy() {
        return new AspiringChampionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || permanent == null || !permanent.sacrifice(source, game)) {
            return false;
        }
        CardsImpl toReveal = new CardsImpl();
        Card card = AspiringChampionEffect.getCard(player, (Cards)toReveal, game);
        player.revealCards(source, (Cards)toReveal, game);
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        toReveal.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)toReveal, game, source, false);
        player.shuffleLibrary(source, game);
        game.processAction();
        Permanent creature = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (creature == null || !creature.hasSubtype(SubType.DEMON, game) || creature.getPower().getValue() < 1) {
            return true;
        }
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(playerId);
            if (opponent == null) continue;
            opponent.damage(creature.getPower().getValue(), creature.getId(), source, game);
        }
        return true;
    }

    private static Card getCard(Player player, Cards toReveal, Game game) {
        for (Card card : player.getLibrary().getCards(game)) {
            toReveal.add(card);
            if (!card.isCreature(game)) continue;
            return card;
        }
        return null;
    }
}

