/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.a.AssimilationAegisCopyEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class AssimilationAegisEffect
extends OneShotEffect {
    AssimilationAegisEffect() {
        super(Outcome.Benefit);
        this.staticText = "for as long as {this} remains attached to it, that creature becomes a copy of a creature card exiled with {this}";
    }

    private AssimilationAegisEffect(AssimilationAegisEffect effect) {
        super((OneShotEffect)effect);
    }

    public AssimilationAegisEffect copy() {
        return new AssimilationAegisEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent attachedPermanent = (Permanent)this.getValue("attachedPermanent");
        Permanent equipment = source.getSourcePermanentIfItStillExists(game);
        if (attachedPermanent == null || equipment == null || !equipment.isAttachedTo(attachedPermanent.getId())) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        UUID exileId = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
        TargetCardInExile target = new TargetCardInExile((FilterCard)StaticFilters.FILTER_CARD_CREATURE, exileId);
        target.withNotTarget(true);
        if (!target.choose(Outcome.Benefit, player.getId(), source.getId(), source, game)) {
            return false;
        }
        Card copyCard = game.getCard(target.getFirstTarget());
        if (copyCard == null) {
            return false;
        }
        game.addEffect((ContinuousEffect)new AssimilationAegisCopyEffect(copyCard, attachedPermanent), source);
        return true;
    }
}

