/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Library;
import mage.players.Player;

class AtlaPalaniNestTenderEffect
extends OneShotEffect {
    AtlaPalaniNestTenderEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal cards from the top of your library until you reveal a creature card. Put that card onto the battlefield and the rest on the bottom of your library in a random order";
    }

    private AtlaPalaniNestTenderEffect(AtlaPalaniNestTenderEffect effect) {
        super((OneShotEffect)effect);
    }

    public AtlaPalaniNestTenderEffect copy() {
        return new AtlaPalaniNestTenderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Library library = player.getLibrary();
        if (!library.hasCards()) {
            return true;
        }
        CardsImpl cards = new CardsImpl();
        Card toBattlefield = null;
        for (Card card : library.getCards(game)) {
            cards.add(card);
            if (!card.isCreature(game)) continue;
            toBattlefield = card;
            break;
        }
        if (toBattlefield != null) {
            player.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game);
        }
        player.revealCards(source, (Cards)cards, game);
        cards.remove(toBattlefield);
        if (!cards.isEmpty()) {
            player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        return true;
    }
}

