/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.AuraCardCanAttachToLKIPermanentId;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class AuratouchedMageEffect
extends OneShotEffect {
    AuratouchedMageEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "search your library for an Aura card that could enchant it. If {this} is still on the battlefield, put that Aura card onto the battlefield attached to it. Otherwise, reveal the Aura card and put it into your hand. Then shuffle";
    }

    private AuratouchedMageEffect(AuratouchedMageEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            FilterCard filter = new FilterCard("aura that could enchant " + source.getSourceObject(game).getName());
            filter.add((Predicate)SubType.AURA.getPredicate());
            filter.add((Predicate)new AuraCardCanAttachToLKIPermanentId(source.getSourceId()));
            TargetCardInLibrary target = new TargetCardInLibrary(filter);
            target.withNotTarget(true);
            if (controller.searchLibrary(target, source, game) && target.getFirstTarget() != null) {
                Card aura = game.getCard(target.getFirstTarget());
                Permanent auratouchedMage = source.getSourcePermanentIfItStillExists(game);
                if (aura != null && auratouchedMage != null && game.getState().getZoneChangeCounter(source.getSourceId()) == source.getStackMomentSourceZCC()) {
                    game.getState().setValue("attachTo:" + aura.getId(), (Object)auratouchedMage);
                    if (controller.moveCards(aura, Zone.BATTLEFIELD, source, game)) {
                        auratouchedMage.addAttachment(aura.getId(), source, game);
                    }
                } else {
                    CardsImpl auraRevealed = new CardsImpl(aura);
                    controller.revealCards(source, (Cards)auraRevealed, game);
                    controller.moveCards(aura, Zone.HAND, source, game);
                }
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    public AuratouchedMageEffect copy() {
        return new AuratouchedMageEffect(this);
    }
}

