/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class AureliaTheLawAboveTriggeredAbility
extends TriggeredAbilityImpl {
    private final int amount;

    AureliaTheLawAboveTriggeredAbility(Effect effect, int amount) {
        super(Zone.BATTLEFIELD, effect);
        this.amount = amount;
        this.setTriggerPhrase("Whenever a player attacks with " + CardUtil.numberToText((int)amount) + " or more creatures, ");
    }

    private AureliaTheLawAboveTriggeredAbility(AureliaTheLawAboveTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
        this.amount = ability.amount;
    }

    public AureliaTheLawAboveTriggeredAbility copy() {
        return new AureliaTheLawAboveTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return game.getCombat().getAttackers().size() >= this.amount;
    }
}

