/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.TargetSource;

class AuriokReplicaEffect
extends PreventionEffectImpl {
    private final TargetSource target;

    public AuriokReplicaEffect() {
        super(Duration.EndOfTurn);
        this.staticText = "prevent all damage a source of your choice would deal to you this turn";
        this.target = new TargetSource();
    }

    private AuriokReplicaEffect(AuriokReplicaEffect effect) {
        super((PreventionEffectImpl)effect);
        this.target = effect.target.copy();
    }

    public AuriokReplicaEffect copy() {
        return new AuriokReplicaEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.target.choose(Outcome.PreventDamage, source.getControllerId(), source.getSourceId(), source, game);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return super.applies(event, source, game) && event.getTargetId().equals(source.getControllerId()) && event.getSourceId().equals(this.target.getFirstTarget());
    }
}

