/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class AuthorOfShadowsEffect
extends OneShotEffect {
    AuthorOfShadowsEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile all opponents' graveyards. Choose a nonland card exiled this way. You may cast that card for as long as it remains exiled, and you may spend mana as though it were mana of any color to cast that spell";
    }

    private AuthorOfShadowsEffect(AuthorOfShadowsEffect effect) {
        super((OneShotEffect)effect);
    }

    public AuthorOfShadowsEffect copy() {
        return new AuthorOfShadowsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        game.getOpponents(source.getControllerId(), true).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getGraveyard).forEach(arg_0 -> ((Cards)cards).addAll(arg_0));
        cards.removeIf(Objects::isNull);
        if (cards.isEmpty()) {
            return false;
        }
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.retainZone(Zone.EXILED, game);
        if (cards.isEmpty()) {
            return false;
        }
        TargetCardInExile target = new TargetCardInExile((FilterCard)StaticFilters.FILTER_CARD_A_NON_LAND);
        target.withNotTarget(true);
        controller.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return true;
        }
        String exileZoneName = controller.getName() + " - Author of Shadows - cast with any color";
        UUID exileZoneId = CardUtil.getExileZoneId((String)exileZoneName, (Game)game);
        ExileZone exileZone = game.getExile().createZone(exileZoneId, exileZoneName);
        game.getExile().moveToAnotherZone(card, game, exileZone);
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.Custom, (boolean)true);
        return true;
    }
}

