/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class AutumnWillowEffect
extends AsThoughEffectImpl {
    AutumnWillowEffect() {
        super(AsThoughEffectType.SHROUD, Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "Until end of turn, {this} can be the target of spells and abilities controlled by target player as though it didn't have shroud";
    }

    private AutumnWillowEffect(AutumnWillowEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public AutumnWillowEffect copy() {
        return new AutumnWillowEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        if (!affectedControllerId.equals(source.getFirstTarget())) {
            return false;
        }
        Permanent creature = game.getPermanent(sourceId);
        return creature != null && sourceId.equals(source.getSourceId());
    }
}

