/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.condition.Condition;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.TransformSourceEffect;
import mage.cards.a.AvatarAangWatcher;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class AvatarAangTriggeredAbility
extends TriggeredAbilityImpl {
    AvatarAangTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1));
        this.addEffect((Effect)new ConditionalOneShotEffect((OneShotEffect)new TransformSourceEffect(), (Condition)AvatarAangCondition.instance, "Then if you've done all four this turn, transform {this}"));
        this.setTriggerPhrase("Whenever you waterbend, earthbend, firebend, or airbend, ");
        this.addWatcher(new AvatarAangWatcher());
    }

    private AvatarAangTriggeredAbility(AvatarAangTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AvatarAangTriggeredAbility copy() {
        return new AvatarAangTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case EARTHBENDED: 
            case AIRBENDED: 
            case FIREBENDED: 
            case WATERBENDED: {
                return true;
            }
        }
        return false;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return this.isControlledBy(event.getPlayerId());
    }

    private static enum AvatarAangCondition implements Condition
    {
        instance;


        public boolean apply(Game game, Ability source) {
            return AvatarAangWatcher.checkPlayer(game, source);
        }
    }
}

