/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class AvatarAangWatcher
extends Watcher {
    private final Set<UUID> earthSet = new HashSet<UUID>();
    private final Set<UUID> airSet = new HashSet<UUID>();
    private final Set<UUID> fireSet = new HashSet<UUID>();
    private final Set<UUID> waterSet = new HashSet<UUID>();

    AvatarAangWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case EARTHBENDED: {
                this.earthSet.add(event.getPlayerId());
                return;
            }
            case AIRBENDED: {
                this.airSet.add(event.getPlayerId());
                return;
            }
            case FIREBENDED: {
                this.fireSet.add(event.getPlayerId());
                return;
            }
            case WATERBENDED: {
                this.waterSet.add(event.getPlayerId());
            }
        }
    }

    public void reset() {
        super.reset();
        this.earthSet.clear();
        this.airSet.clear();
        this.fireSet.clear();
        this.earthSet.clear();
    }

    private boolean checkPlayer(UUID playerId) {
        return this.earthSet.contains(playerId) && this.airSet.contains(playerId) && this.fireSet.contains(playerId) && this.earthSet.contains(playerId);
    }

    static boolean checkPlayer(Game game, Ability source) {
        return ((AvatarAangWatcher)game.getState().getWatcher(AvatarAangWatcher.class)).checkPlayer(source.getControllerId());
    }
}

