/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.condition.common.ThresholdCondition;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainProtectionFromColorAllEffect;
import mage.constants.AbilityWord;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;

class AvenWarcraftEffect
extends OneShotEffect {
    AvenWarcraftEffect() {
        super(Outcome.Benefit);
        this.staticText = "<br>" + AbilityWord.THRESHOLD.formatWord() + "If seven or more cards are in your graveyard, choose a color. Creatures you control also gain protection from the chosen color until end of turn";
    }

    private AvenWarcraftEffect(AvenWarcraftEffect effect) {
        super((OneShotEffect)effect);
    }

    public AvenWarcraftEffect copy() {
        return new AvenWarcraftEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (ThresholdCondition.instance.apply(game, source)) {
            game.addEffect((ContinuousEffect)new GainProtectionFromColorAllEffect(Duration.EndOfTurn, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURES), source);
        }
        return true;
    }
}

