/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AvengerEnDalEffect
extends OneShotEffect {
    AvengerEnDalEffect() {
        super(Outcome.GainLife);
        this.staticText = "Its controller gains life equal to its toughness";
    }

    private AvengerEnDalEffect(AvengerEnDalEffect effect) {
        super((OneShotEffect)effect);
    }

    public AvengerEnDalEffect copy() {
        return new AvengerEnDalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent != null) {
            Player player = game.getPlayer(permanent.getControllerId());
            if (player != null) {
                player.gainLife(permanent.getToughness().getValue(), game, source);
            }
            return true;
        }
        return false;
    }
}

