/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TreasureToken;
import mage.watchers.Watcher;
import mage.watchers.common.BoostCountersAddedFirstTimeWatcher;

class AxgardArtisanTriggeredAbility
extends TriggeredAbilityImpl {
    AxgardArtisanTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new TreasureToken()));
        this.setTriggerPhrase("Whenever one or more +1/+1 counters are put on {this} for the first time each turn, ");
        this.addWatcher((Watcher)new BoostCountersAddedFirstTimeWatcher());
    }

    private AxgardArtisanTriggeredAbility(AxgardArtisanTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AxgardArtisanTriggeredAbility copy() {
        return new AxgardArtisanTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && this.getSourceId().equals(event.getTargetId()) && event.getData().equals(CounterType.P1P1.getName()) && BoostCountersAddedFirstTimeWatcher.checkEvent((GameEvent)event, (Permanent)permanent, (Game)game, (int)0);
    }
}

