/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class AzorTheLawbringerAttacksEffect
extends OneShotEffect {
    AzorTheLawbringerAttacksEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay {X}{W}{U}{U}. If you do, you gain X life and draw X cards";
    }

    private AzorTheLawbringerAttacksEffect(AzorTheLawbringerAttacksEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ManaCostsImpl cost = new ManaCostsImpl("{X}{W}{U}{U}");
            if (controller.chooseUse(Outcome.Damage, "Pay " + cost.getText() + "? If you do, you gain X life and draw X cards.", source, game)) {
                int costX = controller.announceX(0, Integer.MAX_VALUE, "Announce the value for {X} (gain life and draw cards)", game, source, true);
                cost.add((Object)new GenericManaCost(costX));
                if (cost.pay(source, game, source, source.getControllerId(), false, null)) {
                    controller.resetStoredBookmark(game);
                    controller.gainLife(costX, game, source);
                    controller.drawCards(costX, source, game);
                    return true;
                }
            }
        }
        return false;
    }

    public AzorTheLawbringerAttacksEffect copy() {
        return new AzorTheLawbringerAttacksEffect(this);
    }
}

