/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class AzoriusAEthermageAbility
extends TriggeredAbilityImpl {
    public AzoriusAEthermageAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect, false);
        this.setTriggerPhrase("Whenever a permanent is returned to your hand, ");
    }

    private AzoriusAEthermageAbility(AzoriusAEthermageAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getFromZone() != Zone.BATTLEFIELD || zEvent.getToZone() != Zone.HAND) {
            return false;
        }
        if (!zEvent.getPlayerId().equals(this.controllerId)) {
            return false;
        }
        Permanent permanentThatMoved = zEvent.getTarget();
        if (permanentThatMoved == null) {
            return false;
        }
        return StaticFilters.FILTER_PERMANENT_CREATURE.match(permanentThatMoved, this.controllerId, (Ability)this, game);
    }

    public AzoriusAEthermageAbility copy() {
        return new AzoriusAEthermageAbility(this);
    }
}

