/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetDiscard;

class AzraBladeseekerEffect
extends OneShotEffect {
    AzraBladeseekerEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player on your team may discard a card, then each player who discarded a card this way draws a card";
    }

    private AzraBladeseekerEffect(AzraBladeseekerEffect effect) {
        super((OneShotEffect)effect);
    }

    public AzraBladeseekerEffect copy() {
        return new AzraBladeseekerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<PlayerCard> playerCardList = new ArrayList<PlayerCard>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Card card;
            TargetDiscard target;
            Player player = game.getPlayer(playerId);
            if (player == null || player.hasOpponent(source.getControllerId(), game) || player.getHand().isEmpty() || !player.chooseUse(Outcome.DrawCard, "Discard a card?", source, game) || !(target = new TargetDiscard(playerId)).choose(Outcome.DrawCard, playerId, source.getSourceId(), source, game) || (card = game.getCard(target.getFirstTarget())) == null) continue;
            playerCardList.add(new PlayerCard(player, card));
        }
        for (PlayerCard playerCard : playerCardList) {
            if (!playerCard.getPlayer().discard(playerCard.getCard(), false, source, game)) continue;
            playerCard.getPlayer().drawCards(1, source, game);
        }
        return true;
    }

    static class PlayerCard {
        private final Player player;
        private final Card card;

        private PlayerCard(Player player, Card card) {
            this.player = player;
            this.card = card;
        }

        public Player getPlayer() {
            return this.player;
        }

        public Card getCard() {
            return this.card;
        }
    }
}

