/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.a.AzraOddsmakerDelayedTriggeredAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;
import mage.util.CardUtil;

class AzraOddsmakerEffect
extends OneShotEffect {
    AzraOddsmakerEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a creature. Whenever that creature deals combat damage to a player this turn, you draw two cards";
    }

    private AzraOddsmakerEffect(AzraOddsmakerEffect effect) {
        super((OneShotEffect)effect);
    }

    public AzraOddsmakerEffect copy() {
        return new AzraOddsmakerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Permanent permanent = null;
        TargetCreaturePermanent target = new TargetCreaturePermanent();
        target.withNotTarget(true);
        if (player.choose(Outcome.DrawCard, (Target)target, source, game)) {
            permanent = game.getPermanent(target.getFirstTarget());
        }
        if (permanent == null) {
            return false;
        }
        game.informPlayers(player.getLogName() + " chose " + permanent.getLogName() + ". " + CardUtil.getSourceLogName((Game)game, (Ability)source));
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AzraOddsmakerDelayedTriggeredAbility(new MageObjectReference((MageObject)permanent, game), permanent.getName()), source);
        return true;
    }
}

