/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.choices.Choice;
import mage.choices.ChoiceCardType;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class ChooseCardTypeEffect
extends OneShotEffect {
    public ChooseCardTypeEffect() {
        super(Outcome.Neutral);
        this.staticText = "choose a card type shared among two exiled cards used to craft it.";
    }

    protected ChooseCardTypeEffect(ChooseCardTypeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent mageObject = game.getPermanentEntering(source.getSourceId());
        ArrayList exiledCardsCardType = new ArrayList();
        if (mageObject == null) {
            mageObject = game.getObject(source);
        }
        if (controller != null && mageObject != null) {
            Permanent permanent = source.getSourcePermanentIfItStillExists(game);
            if (permanent == null) {
                return false;
            }
            ExileZone exileZone = game.getState().getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source, (int)(game.getState().getZoneChangeCounter(mageObject.getId()) - 1)));
            if (exileZone == null) {
                return false;
            }
            for (Card card : exileZone.getCards(game)) {
                exiledCardsCardType.addAll(card.getCardType(game));
            }
            ChoiceCardType cardTypeChoice = new ChoiceCardType();
            cardTypeChoice.getChoices().clear();
            cardTypeChoice.getChoices().addAll(exiledCardsCardType.stream().map(CardType::toString).collect(Collectors.toList()));
            HashMap<String, Integer> cardTypeCounts = new HashMap<String, Integer>();
            for (String cardType : cardTypeChoice.getChoices()) {
                cardTypeCounts.put(cardType, 0);
            }
            for (Card c : exileZone.getCards(game)) {
                for (CardType cardType : c.getCardType(game)) {
                    if (!cardTypeCounts.containsKey(cardType.toString())) continue;
                    cardTypeCounts.put(cardType.toString(), (Integer)cardTypeCounts.get(cardType.toString()) + 1);
                }
            }
            ArrayList sharedCardTypes = new ArrayList();
            int numExiledCards = exileZone.getCards(game).size();
            for (Map.Entry entry : cardTypeCounts.entrySet()) {
                if ((Integer)entry.getValue() != numExiledCards) continue;
                sharedCardTypes.add(entry.getKey());
            }
            if (sharedCardTypes.isEmpty()) {
                game.informPlayers(mageObject.getIdName() + " No exiled cards shared a type in exile, so nothing is done.");
                if (mageObject instanceof Permanent) {
                    mageObject.addInfo("chosen type", CardUtil.addToolTipMarkTags((String)"No exiled cards have the same card type."), game);
                }
                return false;
            }
            cardTypeChoice.getChoices().retainAll(sharedCardTypes);
            if (controller.choose(Outcome.Benefit, (Choice)cardTypeChoice, game)) {
                if (!game.isSimulation()) {
                    game.informPlayers(mageObject.getName() + ": " + controller.getLogName() + " has chosen " + cardTypeChoice.getChoice());
                }
                game.getState().setValue("ApexObservatoryType_" + source.getSourceId().toString(), (Object)cardTypeChoice.getChoice());
                if (mageObject instanceof Permanent) {
                    mageObject.addInfo("chosen type", CardUtil.addToolTipMarkTags((String)("Chosen card type: " + cardTypeChoice.getChoice())), game);
                }
                return true;
            }
        }
        return false;
    }

    public ChooseCardTypeEffect copy() {
        return new ChooseCardTypeEffect(this);
    }
}

