/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class TokTokVolcanoBornEffect
extends ReplacementEffectImpl {
    TokTokVolcanoBornEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a red source would deal damage to a player, it deals that much damage plus 1 to that player instead";
    }

    private TokTokVolcanoBornEffect(TokTokVolcanoBornEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        Object sourceObject = sourcePermanent == null ? game.getObject(event.getSourceId()) : sourcePermanent;
        return sourceObject != null && sourceObject.getColor(game).isRed();
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() + 1);
        return false;
    }

    public TokTokVolcanoBornEffect copy() {
        return new TokTokVolcanoBornEffect(this);
    }
}

