/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BackFromTheBrinkCost
extends CostImpl {
    public BackFromTheBrinkCost() {
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD);
        target.withNotTarget(true);
        this.addTarget((Target)target);
        this.text = "Exile a creature card from your graveyard and pay its mana cost";
    }

    private BackFromTheBrinkCost(BackFromTheBrinkCost cost) {
        super((CostImpl)cost);
    }

    public BackFromTheBrinkCost copy() {
        return new BackFromTheBrinkCost(this);
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.canChooseOrAlreadyChosen(ability, source, controllerId, game);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Card card;
        Player controller;
        if (this.getTargets().choose(Outcome.Exile, controllerId, source.getSourceId(), source, game) && (controller = game.getPlayer(controllerId)) != null && (card = controller.getGraveyard().get(this.getTargets().getFirstTarget(), game)) != null && controller.moveCards(card, Zone.EXILED, ability, game)) {
            ((Effect)ability.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game.getState().getZoneChangeCounter(card.getId())));
            this.paid = card.getManaCost().pay(ability, game, source, controllerId, noMana);
        }
        return this.paid;
    }
}

