/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class BalshanBeguilerEffect
extends OneShotEffect {
    BalshanBeguilerEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player reveals the top two cards of their library. You choose one of those cards and put it into their graveyard.";
    }

    private BalshanBeguilerEffect(BalshanBeguilerEffect effect) {
        super((OneShotEffect)effect);
    }

    public BalshanBeguilerEffect copy() {
        return new BalshanBeguilerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player you = game.getPlayer(source.getControllerId());
        if (player == null || you == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        cards.addAllCards((Collection)player.getLibrary().getTopCards(game, 2));
        if (cards.isEmpty()) {
            return false;
        }
        player.revealCards(source, (Cards)cards, game);
        TargetCardInLibrary target = new TargetCardInLibrary();
        if (you.choose(Outcome.Benefit, (Cards)cards, (TargetCard)target, source, game)) {
            Card card = player.getLibrary().getCard(target.getFirstTarget(), game);
            you.moveCards(card, Zone.GRAVEYARD, source, game);
        }
        return true;
    }
}

