/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class BaneOfBalaGedEffect
extends OneShotEffect {
    BaneOfBalaGedEffect() {
        super(Outcome.Benefit);
        this.staticText = "defending player exiles two permanents they control";
    }

    private BaneOfBalaGedEffect(BaneOfBalaGedEffect effect) {
        super((OneShotEffect)effect);
    }

    public BaneOfBalaGedEffect copy() {
        return new BaneOfBalaGedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player defendingPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (defendingPlayer != null) {
            TargetControlledPermanent target = new TargetControlledPermanent(2);
            defendingPlayer.chooseTarget(this.outcome, (Target)target, source, game);
            Set toExile = target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
            defendingPlayer.moveCards(toExile, Zone.EXILED, source, game);
            return true;
        }
        return false;
    }
}

