/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.b.BaralAndKariZevEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.common.SpellsCastWatcher;

class BaralAndKariZevTriggeredAbility
extends TriggeredAbilityImpl {
    BaralAndKariZevTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BaralAndKariZevEffect());
    }

    private BaralAndKariZevTriggeredAbility(BaralAndKariZevTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public BaralAndKariZevTriggeredAbility copy() {
        return new BaralAndKariZevTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getSpell(event.getTargetId());
        if (spell == null || !spell.isInstantOrSorcery(game)) {
            return false;
        }
        List spells = ((SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class)).getSpellsCastThisTurn(this.getControllerId()).stream().filter(s -> s.isInstantOrSorcery(game)).collect(Collectors.toList());
        if (spells.size() != 1 || !((Spell)spells.get(0)).getId().equals(spell.getId())) {
            return false;
        }
        this.getEffects().setValue("spellCast", (Object)spell);
        return true;
    }

    public String getRule() {
        return "Whenever you cast your first instant or sorcery spell each turn, you may cast a spell with lesser mana value that shares a card type with it from your hand without paying its mana cost. If you don't, create First Mate Ragavan, a legendary 2/1 red Monkey Pirate creature token. It gains haste until end of turn.";
    }
}

