/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.MageObject;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.b.BaronVonCountMoveDoomCounterEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

class BaronVonCountTriggeredAbility
extends TriggeredAbilityImpl {
    public BaronVonCountTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BaronVonCountMoveDoomCounterEffect());
        this.setTriggerPhrase("Whenever you cast a spell with the indicated numeral in its mana cost, text box, power, or toughness, ");
    }

    private BaronVonCountTriggeredAbility(BaronVonCountTriggeredAbility abiltity) {
        super((TriggeredAbilityImpl)abiltity);
    }

    public BaronVonCountTriggeredAbility copy() {
        return new BaronVonCountTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getPlayerId().equals(this.getControllerId())) {
            Permanent sourcePermanent = game.getPermanent(this.getSourceId());
            MageObject mageObject = game.getObject(this.getSourceId());
            Spell spell = game.getStack().getSpell(event.getTargetId());
            if (spell == null || sourcePermanent == null || mageObject == null) {
                return false;
            }
            Integer doomNumber = (Integer)game.getState().getValue(mageObject.getId() + "_doom");
            if (doomNumber == null || doomNumber == 0) {
                return false;
            }
            if (!spell.isFaceDown(game)) {
                String doomString = doomNumber.toString();
                if (spell.getCard().getManaCost().getText().contains(doomString) || String.valueOf(spell.getPower().getBaseValue()).contains(doomString) || String.valueOf(spell.getToughness().getBaseValue()).contains(doomString)) {
                    return true;
                }
                for (String string : spell.getCard().getRules(game)) {
                    if (!string.contains(doomString)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

