/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

class BarrinTolarianArchmageWatcher
extends Watcher {
    private final Set<UUID> playerSet = new HashSet<UUID>();

    BarrinTolarianArchmageWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE) {
            return;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getFromZone() == Zone.BATTLEFIELD && zEvent.getToZone() == Zone.HAND) {
            this.playerSet.add(zEvent.getTarget().getOwnerId());
        }
    }

    public void reset() {
        this.playerSet.clear();
        super.reset();
    }

    boolean checkPlayer(UUID playerId) {
        return this.playerSet.contains(playerId);
    }
}

