/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Objects;
import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.targetpointer.SecondTargetPointer;
import mage.target.targetpointer.TargetPointer;

class BarroomBrawlEffect
extends OneShotEffect {
    BarroomBrawlEffect() {
        super(Outcome.Benefit);
        this.setTargetPointer((TargetPointer)new SecondTargetPointer());
        this.staticText = "Then that player may copy this spell and may choose new targets for the copy";
    }

    private BarroomBrawlEffect(BarroomBrawlEffect effect) {
        super((OneShotEffect)effect);
    }

    public BarroomBrawlEffect copy() {
        return new BarroomBrawlEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = Optional.ofNullable(this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source)).filter(Objects::nonNull).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).orElse(null);
        Spell spell = game.getSpellOrLKIStack(source.getSourceId());
        if (player != null && spell != null && player.chooseUse(this.outcome, "Copy the spell?", source, game)) {
            spell.createCopyOnStack(game, source, player.getId(), true);
            return true;
        }
        return false;
    }
}

