/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.WallToken;
import mage.players.Player;

class BasaltGolemEffect
extends OneShotEffect {
    BasaltGolemEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "that creature's controller sacrifices it. If the player does, they create a 0/2 colorless Wall artifact creature token with defender";
    }

    private BasaltGolemEffect(BasaltGolemEffect effect) {
        super((OneShotEffect)effect);
    }

    public BasaltGolemEffect copy() {
        return new BasaltGolemEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (creature == null) {
            return false;
        }
        Player player = game.getPlayer(creature.getControllerId());
        if (player == null) {
            return false;
        }
        if (!creature.sacrifice(source, game)) {
            return false;
        }
        return new WallToken().putOntoBattlefield(1, game, source, player.getId());
    }
}

