/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class BattlefieldImprovisationEquipEffect
extends OneShotEffect {
    BattlefieldImprovisationEquipEffect() {
        super(Outcome.Benefit);
        this.staticText = "If that creature is attacking, you may attach any number of Equipment you control to it.";
    }

    private BattlefieldImprovisationEquipEffect(BattlefieldImprovisationEquipEffect effect) {
        super((OneShotEffect)effect);
    }

    public BattlefieldImprovisationEquipEffect copy() {
        return new BattlefieldImprovisationEquipEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        FilterControlledPermanent equipmentFilter = new FilterControlledPermanent(SubType.EQUIPMENT);
        Permanent attacker = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (attacker != null && attacker.isAttacking()) {
            TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, (FilterPermanent)equipmentFilter, true);
            target.withChooseHint("equip to " + attacker.getLogName());
            controller.choose(this.outcome, (Target)target, source, game);
            for (UUID targetId : target.getTargets()) {
                attacker.addAttachment(targetId, source, game);
                game.informPlayers(game.getPermanent(targetId).getLogName() + " was attached to " + attacker.getLogName());
            }
        }
        return true;
    }
}

