/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.events.PreventDamageEvent;
import mage.game.events.PreventedDamageEvent;
import mage.players.Player;

class BattletideAlchemistEffect
extends PreventionEffectImpl {
    BattletideAlchemistEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "If a source would deal damage to a player, you may prevent X of that damage, where X is the number of Clerics you control";
    }

    private BattletideAlchemistEffect(BattletideAlchemistEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public BattletideAlchemistEffect copy() {
        return new BattletideAlchemistEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        PreventDamageEvent preventEvent;
        int numberOfClericsControlled;
        int toPrevent;
        boolean result = false;
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(event.getTargetId());
        if (controller != null && targetPlayer != null && (toPrevent = Math.min(numberOfClericsControlled = new PermanentsOnBattlefieldCount((FilterPermanent)new FilterControlledPermanent(SubType.CLERIC, "Clerics")).calculate(game, source, (Effect)this), event.getAmount())) > 0 && controller.chooseUse(Outcome.PreventDamage, "Prevent " + toPrevent + " damage to " + targetPlayer.getName() + '?', source, game) && !game.replaceEvent((GameEvent)(preventEvent = new PreventDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), toPrevent, ((DamageEvent)event).isCombatDamage())))) {
            if (event.getAmount() >= toPrevent) {
                event.setAmount(event.getAmount() - toPrevent);
            } else {
                event.setAmount(0);
                result = true;
            }
            game.informPlayers("Battletide Alchemist prevented " + toPrevent + " damage to " + targetPlayer.getName());
            game.fireEvent((GameEvent)new PreventedDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), toPrevent));
        }
        return result;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }
}

