/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterAttackingCreature;
import mage.game.Game;
import mage.players.Player;

class BatwingBrumeEffect
extends OneShotEffect {
    BatwingBrumeEffect() {
        super(Outcome.LoseLife);
    }

    private BatwingBrumeEffect(BatwingBrumeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player;
                int amount = game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterAttackingCreature(), playerId, game).size();
                if (amount <= 0 || (player = game.getPlayer(playerId)) == null) continue;
                player.loseLife(amount, game, source, false);
            }
            return true;
        }
        return false;
    }

    public BatwingBrumeEffect copy() {
        return new BatwingBrumeEffect(this);
    }
}

