/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BeastmasterAscensionEffect
extends BoostControlledEffect {
    BeastmasterAscensionEffect() {
        super(5, 5, Duration.WhileOnBattlefield);
        this.staticText = "As long as {this} has seven or more quest counters on it, creatures you control get +5/+5";
    }

    private BeastmasterAscensionEffect(BeastmasterAscensionEffect effect) {
        super((BoostControlledEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && permanent.getCounters(game).getCount(CounterType.QUEST) > 6) {
            super.apply(game, source);
        }
        return false;
    }

    public BeastmasterAscensionEffect copy() {
        return new BeastmasterAscensionEffect(this);
    }
}

