/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Duration;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class BeckTriggeredAbility
extends DelayedTriggeredAbility {
    BeckTriggeredAbility() {
        super((Effect)new DrawCardSourceControllerEffect(1), Duration.EndOfTurn, false, true);
    }

    private BeckTriggeredAbility(BeckTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        UUID targetId = event.getTargetId();
        Permanent permanent = game.getPermanent(targetId);
        return StaticFilters.FILTER_PERMANENT_CREATURE.match(permanent, this.getControllerId(), (Ability)this, game);
    }

    public BeckTriggeredAbility copy() {
        return new BeckTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature enters the battlefield this turn, you may draw a card.";
    }
}

