/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.game.Game;
import mage.game.permanent.Permanent;

enum BecomeThePilotCondition implements Condition
{
    instance;

    private static final Hint hint;

    public static Hint getHint() {
        return hint;
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).filter(Objects::nonNull).map(Permanent::getAttachedTo).map(arg_0 -> ((Game)game).getPermanent(arg_0)).orElse(null);
        if (permanent == null) {
            return false;
        }
        UUID defenderId = game.getCombat().getDefenderId(permanent.getId());
        return defenderId == null || !permanent.isOwnedBy(defenderId) && !permanent.isOwnedBy(game.getControllerId(defenderId));
    }

    static {
        hint = new ConditionHint((Condition)instance, "Enchanted creature is not attacking its owner or a permanent its owner controls");
    }
}

