/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BehemothOfVaultDoWhenCostPaid
extends OneShotEffect {
    private final ReflexiveTriggeredAbility ability;

    BehemothOfVaultDoWhenCostPaid(ReflexiveTriggeredAbility ability) {
        super(Outcome.Benefit);
        this.ability = ability;
        this.staticText = "you may pay an amount of {E} equal to target nonland permanent's mana value. When you do, destroy that permanent.";
    }

    BehemothOfVaultDoWhenCostPaid(BehemothOfVaultDoWhenCostPaid effect) {
        super((OneShotEffect)effect);
        this.ability = effect.ability.copy();
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent targetPermanent = game.getPermanent(source.getFirstTarget());
        if (targetPermanent == null || player == null) {
            return false;
        }
        PayEnergyCost cost = new PayEnergyCost(targetPermanent.getManaValue());
        if (!cost.canPay(source, source, player.getId(), game) || !player.chooseUse(Outcome.DestroyPermanent, cost.getText(), source, game)) {
            return true;
        }
        cost.clearPaid();
        int bookmark = game.bookmarkState();
        if (cost.pay(source, game, source, player.getId(), false)) {
            this.ability.getEffects().setTargetPointer((TargetPointer)new FixedTarget(targetPermanent, game));
            game.fireReflexiveTriggeredAbility(this.ability, source);
            player.resetStoredBookmark(game);
            return true;
        }
        player.restoreState(bookmark, BehemothOfVaultDoWhenCostPaid.class.getName(), game);
        return true;
    }

    public void setValue(String key, Object value) {
        super.setValue(key, value);
        this.ability.getEffects().setValue(key, value);
    }

    public BehemothOfVaultDoWhenCostPaid copy() {
        return new BehemothOfVaultDoWhenCostPaid(this);
    }
}

