/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BelakorTheDarkMasterEffect
extends OneShotEffect {
    BelakorTheDarkMasterEffect() {
        super(Outcome.Damage);
        this.staticText = "it deals damage equal to its power to any target";
    }

    private BelakorTheDarkMasterEffect(BelakorTheDarkMasterEffect effect) {
        super((OneShotEffect)effect);
    }

    public BelakorTheDarkMasterEffect copy() {
        return new BelakorTheDarkMasterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer;
        Permanent permanent = (Permanent)this.getValue("permanentEnteringBattlefield");
        if (permanent == null) {
            return false;
        }
        int power = permanent.getPower().getValue();
        if (power < 1) {
            return false;
        }
        UUID targetId = this.getTargetPointer().getFirst(game, source);
        Permanent targetPermanent = game.getPermanent(targetId);
        if (targetPermanent != null) {
            targetPermanent.damage(power, permanent.getId(), source, game);
        }
        if ((targetPlayer = game.getPlayer(targetId)) != null) {
            targetPlayer.damage(power, permanent.getId(), source, game);
        }
        return true;
    }
}

