/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.FilterPlayer;
import mage.filter.common.FilterControlledLandPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.other.PlayerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.players.PlayerList;
import mage.target.Target;
import mage.target.TargetPlayer;
import mage.target.common.TargetControlledPermanent;

class BendOrBreakEffect
extends OneShotEffect {
    public BendOrBreakEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Each player separates all nontoken lands they control into two piles. For each player, one of their piles is chosen by one of their opponents of their choice. Destroy all lands in the chosen piles. Tap all lands in the other piles";
    }

    private BendOrBreakEffect(BendOrBreakEffect effect) {
        super((OneShotEffect)effect);
    }

    public BendOrBreakEffect copy() {
        return new BendOrBreakEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        LinkedHashMap<UUID, Object> playerPermanents = new LinkedHashMap<UUID, Object>();
        PlayerList playerList = game.getState().getPlayerList().copy();
        while (!((UUID)playerList.get()).equals(source.getControllerId()) && controller.canRespond()) {
            playerList.getNext();
        }
        Player currentPlayer = game.getPlayer((UUID)playerList.get());
        UUID firstNextPlayer = null;
        while (!this.getNextPlayerInDirection(true, playerList).equals(firstNextPlayer) && controller.canRespond()) {
            Player nextPlayer = game.getPlayer((UUID)playerList.get());
            if (nextPlayer == null) {
                return false;
            }
            if (firstNextPlayer == null) {
                firstNextPlayer = nextPlayer.getId();
            }
            if (!nextPlayer.canRespond() || currentPlayer == null || !game.getState().getPlayersInRange(controller.getId(), game).contains((Object)currentPlayer.getId())) continue;
            ArrayList<Permanent> firstPile = new ArrayList<Permanent>();
            ArrayList<Permanent> secondPile = new ArrayList<Permanent>();
            FilterControlledLandPermanent filter = new FilterControlledLandPermanent("lands you control to assign to the first pile (lands not chosen will be assigned to the second pile)");
            TargetControlledPermanent target = new TargetControlledPermanent(0, Integer.MAX_VALUE, (FilterControlledPermanent)filter, true);
            if (!target.canChoose(currentPlayer.getId(), source, game)) continue;
            currentPlayer.chooseTarget(Outcome.Neutral, (Target)target, source, game);
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, currentPlayer.getId(), game)) {
                if (target.getTargets().contains(permanent.getId())) {
                    firstPile.add(permanent);
                    continue;
                }
                secondPile.add(permanent);
            }
            StringBuilder sb = new StringBuilder("First pile of ").append(currentPlayer.getLogName()).append(": ");
            sb.append(firstPile.stream().map(MageObject::getLogName).collect(Collectors.joining(", ")));
            game.informPlayers(sb.toString());
            sb = new StringBuilder("Second pile of ").append(currentPlayer.getLogName()).append(": ");
            sb.append(secondPile.stream().map(MageObject::getLogName).collect(Collectors.joining(", ")));
            game.informPlayers(sb.toString());
            ArrayList playerPiles = new ArrayList();
            playerPiles.add(firstPile);
            playerPiles.add(secondPile);
            playerPermanents.put(currentPlayer.getId(), playerPiles);
            currentPlayer = nextPlayer;
        }
        for (Map.Entry playerPiles : playerPermanents.entrySet()) {
            List lists;
            Player chosenOpponent;
            player = game.getPlayer((UUID)playerPiles.getKey());
            if (player == null) continue;
            FilterPlayer filter = new FilterPlayer("opponent");
            ArrayList<PlayerIdPredicate> opponentPredicates = new ArrayList<PlayerIdPredicate>();
            for (UUID opponentId : game.getOpponents(player.getId())) {
                opponentPredicates.add(new PlayerIdPredicate(opponentId));
            }
            filter.add(Predicates.or(opponentPredicates));
            TargetPlayer target = new TargetPlayer(1, 1, true, filter);
            target.setTargetController(player.getId());
            target.setAbilityController(source.getControllerId());
            if (!player.chooseTarget(this.outcome, (Target)target, source, game) || (chosenOpponent = game.getPlayer(target.getFirstTarget())) == null) continue;
            List firstPile = (List)((List)playerPiles.getValue()).get(0);
            List secondPile = (List)((List)playerPiles.getValue()).get(1);
            game.informPlayers(player.getLogName() + " chose " + chosenOpponent.getLogName() + " to choose their pile");
            if (chosenOpponent.choosePile(this.outcome, "Piles of " + player.getName(), firstPile, secondPile, game)) {
                lists = (List)playerPiles.getValue();
                lists.clear();
                lists.add(firstPile);
                lists.add(secondPile);
                game.informPlayers(player.getLogName() + " will have their first pile destroyed");
                continue;
            }
            lists = (List)playerPiles.getValue();
            lists.clear();
            lists.add(secondPile);
            lists.add(firstPile);
            game.informPlayers(player.getLogName() + " will have their second pile destroyed");
        }
        for (Map.Entry playerPiles : playerPermanents.entrySet()) {
            player = game.getPlayer((UUID)playerPiles.getKey());
            if (player == null) continue;
            List pileToSac = (List)((List)playerPiles.getValue()).get(0);
            List pileToTap = (List)((List)playerPiles.getValue()).get(1);
            for (Permanent permanent : pileToSac) {
                if (permanent == null) continue;
                permanent.destroy(source, game, false);
            }
            for (Permanent permanent : pileToTap) {
                if (permanent == null) continue;
                permanent.tap(source, game);
            }
        }
        return true;
    }

    private UUID getNextPlayerInDirection(boolean left, PlayerList playerList) {
        UUID nextPlayerId = left ? (UUID)playerList.getNext() : (UUID)playerList.getPrevious();
        return nextPlayerId;
    }
}

