/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetOpponent;

class BenevolentOfferingEffect2
extends OneShotEffect {
    BenevolentOfferingEffect2() {
        super(Outcome.Sacrifice);
        this.staticText = "<br>Choose an opponent. You gain 2 life for each creature you control and that player gains 2 life for each creature they control";
    }

    private BenevolentOfferingEffect2(BenevolentOfferingEffect2 effect) {
        super((OneShotEffect)effect);
    }

    public BenevolentOfferingEffect2 copy() {
        return new BenevolentOfferingEffect2(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetOpponent target = new TargetOpponent(true);
        target.choose(Outcome.Sacrifice, source.getControllerId(), source.getSourceId(), source, game);
        Player opponent = game.getPlayer(target.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        int count = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, controller.getId(), game) * 2;
        controller.gainLife(count, game, source);
        count = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, opponent.getId(), game) * 2;
        opponent.gainLife(count, game, source);
        return true;
    }
}

