/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

class BenevolentUnicornEffect
extends ReplacementEffectImpl {
    BenevolentUnicornEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a spell would deal damage to a permanent or player, it deals that much damage minus 1 to that permanent or player instead.";
    }

    private BenevolentUnicornEffect(BenevolentUnicornEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public BenevolentUnicornEffect copy() {
        return new BenevolentUnicornEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() - 1);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT || event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        if (stackObject == null) {
            stackObject = (StackObject)game.getLastKnownInformation(event.getSourceId(), Zone.STACK);
        }
        return stackObject instanceof Spell;
    }
}

